{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 27.01.98 - 19:14:54 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ActiveX,ComObj, MMObj, MMDSMix, MMSlider,
  MMDSMidi, MMCCon, MMDSCon, MMHook, MMDesign, MMDIBCv, MMLevel;

type
  TForm1 = class(TForm)
    btnStop1: TButton;
    btnPlay1: TButton;
    btnOpen1: TButton;
    btnClose1: TButton;
    btnFile1: TButton;
    OpenDialog: TOpenDialog;
    MMDSWaveMixer1: TMMDSWaveMixer;
    Slider1: TMMSlider;
    MidiPlay1: TMMDSMidiChannel;
    MMDesigner1: TMMDesigner;
    MMDSChannelConnector1: TMMDSChannelConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MidiPlay2: TMMDSMidiChannel;
    MMLevel3: TMMLevel;
    MMLevel4: TMMLevel;
    btnStop2: TButton;
    btnPlay2: TButton;
    btnOpen2: TButton;
    btnClose2: TButton;
    btnFile2: TButton;
    MMDSChannelConnector2: TMMDSChannelConnector;
    Slider2: TMMSlider;
    procedure btnOpen1Click(Sender: TObject);
    procedure btnClose1Click(Sender: TObject);
    procedure btnPlay1Click(Sender: TObject);
    procedure btnStop1Click(Sender: TObject);
    procedure btnFile1Click(Sender: TObject);
    procedure MidiPlay1PlayEnd(Sender: TObject);
    procedure Slider1Change(Sender: TObject);
    procedure btnFile2Click(Sender: TObject);
    procedure btnOpen2Click(Sender: TObject);
    procedure btnClose2Click(Sender: TObject);
    procedure btnPlay2Click(Sender: TObject);
    procedure btnStop2Click(Sender: TObject);
    procedure Slider2Change(Sender: TObject);
    procedure MidiPlay2PlayEnd(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnFile1Click(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      MidiPlay1.Close;
      MidiPlay1.FileName := OpenDialog.FileName;
      btnClose1.Enabled:= False;
      btnOpen1.Enabled := True;
      btnPlay1.Enabled := True;
   end;
end;

procedure TForm1.btnOpen1Click(Sender: TObject);
begin
   if not MidiPlay1.Open then
      ShowMessage('Unable to open MidiPlay')
   else
   begin
      btnOpen1.Enabled := False;
      btnClose1.Enabled := True;
   end;
end;

procedure TForm1.btnClose1Click(Sender: TObject);
begin
   MidiPlay1.Close;
   btnOpen1.Enabled := True;
   btnClose1.Enabled := False;
end;

procedure TForm1.btnPlay1Click(Sender: TObject);
begin
   if not MidiPlay1.Play then
      ShowMessage('Unable to start MidiPlay')
   else
   begin
      btnOpen1.Enabled := False;
      btnClose1.Enabled := True;
      btnPlay1.Enabled := False;
      btnStop1.Enabled := True;
   end;
end;

procedure TForm1.btnStop1Click(Sender: TObject);
begin
   MidiPlay1.Stop;
end;

procedure TForm1.MidiPlay1PlayEnd(Sender: TObject);
begin
   btnPlay1.Enabled := True;
   btnStop1.Enabled := False;
end;

procedure TForm1.Slider1Change(Sender: TObject);
begin
   MidiPlay1.Volume := (Slider1.Position+(-400))*10;
end;

procedure TForm1.btnFile2Click(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      MidiPlay2.Close;
      MidiPlay2.FileName := OpenDialog.FileName;
      btnClose2.Enabled:= False;
      btnOpen2.Enabled := True;
      btnPlay2.Enabled := True;
   end;
end;

procedure TForm1.btnOpen2Click(Sender: TObject);
begin
   if not MidiPlay2.Open then
      ShowMessage('Unable to open MidiPlay')
   else
   begin
      btnOpen2.Enabled := False;
      btnClose2.Enabled := True;
   end;
end;

procedure TForm1.btnClose2Click(Sender: TObject);
begin
   MidiPlay2.Close;
   btnOpen2.Enabled := True;
   btnClose2.Enabled := False;
end;

procedure TForm1.btnPlay2Click(Sender: TObject);
begin
   if not MidiPlay2.Play then
      ShowMessage('Unable to start MidiPlay')
   else
   begin
      btnOpen2.Enabled := False;
      btnClose2.Enabled := True;
      btnPlay2.Enabled := False;
      btnStop2.Enabled := True;
   end;
end;

procedure TForm1.btnStop2Click(Sender: TObject);
begin
   MidiPlay2.Stop;
end;

procedure TForm1.Slider2Change(Sender: TObject);
begin
   MidiPlay2.Volume := (Slider2.Position+(-400))*10;
end;

procedure TForm1.MidiPlay2PlayEnd(Sender: TObject);
begin
   btnPlay2.Enabled := True;
   btnStop2.Enabled := False;
end;

end.
